function [L,beta] = Step2_Observer_design(A,B,F,D,C,Mc,Nc,Cx,Ce,K,gamma,P)

[n,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);


% augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];

D_tilde = [D zeros(n,q)];
Mc_bar = [Mc; zeros(2*q,n)];


Q = sdpvar(n+2*q,n+2*q);
Y = sdpvar(n+2*q,p);
beta1 = sdpvar(1,1);
beta2 = sdpvar(1,1);
beta3 = sdpvar(1,1);
beta4 = sdpvar(1,1);
beta5 = sdpvar(1,1);

LMI1 = blkvar();
LMI1(1,1) = beta1*((A+B*K)*P + ((A+B*K)*P)');
LMI1(1,2) = beta1*D_tilde;
LMI1(1,3) = beta1*Mc;
LMI1(1,4) = beta1*P*Nc';
LMI1(1,5) = beta1*P*Cx';

Be = [-B*K F zeros(n,q)];
LMI1(1,6) = Be;
LMI1(1,7) = P*Nc';
LMI1(1,8) = zeros(n,n);
LMI1(1,9) = zeros(n,n+2*q);

LMI1(2,2) = -beta2*gamma*eye(l+q);
LMI1(2,3) = zeros(l+q,n);
LMI1(2,4) = zeros(l+q,n);
LMI1(2,5) = zeros(l+q,n);

LMI1(2,6) = (Q*D_bar)';
LMI1(2,7) = zeros(l+q,n);
LMI1(2,8) = zeros(l+q,n);
LMI1(2,9) = zeros(l+q,n+2*q);

LMI1(3,3) = -beta3*eye(n);
LMI1(3,4) = zeros(n,n);
LMI1(3,5) = zeros(n,n);

LMI1(3,6) = zeros(n,n+2*q);
LMI1(3,7) = zeros(n,n);
LMI1(3,8) = zeros(n,n);
LMI1(3,9) = zeros(n,n+2*q);

LMI1(4,4) = -beta4*eye(n);
LMI1(4,5) = zeros(n,n);

LMI1(4,6) = zeros(n,n+2*q);
LMI1(4,7) = zeros(n,n);
LMI1(4,8) = zeros(n,n);
LMI1(4,9) = zeros(n,n+2*q);

LMI1(5,5) = -beta5*gamma*eye(n);

LMI1(5,6) = zeros(n,n+2*q);
LMI1(5,7) = zeros(n,n);
LMI1(5,8) = zeros(n,n);
LMI1(5,9) = zeros(n,n+2*q);

LMI1(6,6) = (Q*A_bar-Y*C_bar)+(Q*A_bar-Y*C_bar)';
LMI1(6,7) = zeros(n+2*q,n);
LMI1(6,8) = Q*Mc_bar;
LMI1(6,9) = Ce';

LMI1(7,7) = -eye(n);
LMI1(7,8) = zeros(n,n);
LMI1(7,9) = zeros(n,n+2*q);

LMI1(8,8) =-eye(n);
LMI1(8,9) = zeros(n,n+2*q);

LMI1(9,9) = -gamma*eye(n+2*q);

LMI1 = sdpvar(LMI1);

Beta = blkvar();
Beta(1,1) = beta1;
Beta(2,2) = beta2;
Beta(3,3) = beta3;
Beta(4,4) = beta4;
Beta(5,5) = beta5;
Beta = sdpvar(Beta);

obj = trace(Beta);

const = [];
const = [const, Beta >= eps*eye(5)];
const = [const, Q >= eps*eye(n+2*q)];
const = [const, LMI1 <= -eps*eye(8*n+5*q+l)];


ops = sdpsettings('solver','mosek','verbose',0);
optimize(const,obj,ops);

L = inv(value(Q))*value(Y);
beta = value(Beta);



